<?php
require_once 'vendor/autoload.php';

use NFePHP\Common\Certificate;

try {
    // Leitura segura do certificado em modo binário
    $pfxPath = __DIR__ . '/certificado/1.pfx';
    $pfx = file_get_contents($pfxPath); // simples e direto

    // Tenta ler o certificado com a senha fornecida
    $cert = Certificate::readPfx($pfx, 'aej123');

    echo "<h3>✅ Certificado lido com sucesso!</h3>";
    echo "<pre>";
    print_r($cert->toArray());
    echo "</pre>";

} catch (Exception $e) {
    echo "<h3>❌ Erro ao ler certificado:</h3>";
    echo "<pre>" . $e->getMessage() . "</pre>";
}
