<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once 'vendor/autoload.php';

use NFePHP\DA\NFe\Danfe;

// Carrega o XML autorizado
$xml = file_get_contents(__DIR__ . '/xml/nota_autorizada.xml');

try {
    $danfe = new Danfe($xml);
    $danfe->debugMode(false);
    $danfe->creditsIntegratorFooter('EletroInfo Sistemas'); // Nome do sistema ou sua marca
    $pdf = $danfe->render();

    // Exibir o PDF na tela
    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="danfe.pdf"');
    echo $pdf;

} catch (Exception $e) {
    echo "Erro ao gerar DANFE: " . $e->getMessage();
}
