<?php
// formulario.php
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Emissão de NF-e</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body class="container mt-5">

    <h2>Emitir Nota Fiscal Eletrônica</h2>
    <form action="emissor.php" method="POST" class="mt-4">

        <h5>Dados do Cliente</h5>
        <div class="mb-3">
            <label>Nome/Razão Social</label>
            <input type="text" name="cliente_nome" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>CPF/CNPJ</label>
            <input type="text" name="cliente_cpf_cnpj" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Endereço</label>
            <input type="text" name="cliente_endereco" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Município</label>
            <input type="text" name="cliente_municipio" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>UF</label>
            <input type="text" name="cliente_uf" class="form-control" maxlength="2" required>
        </div>

        <h5 class="mt-4">Produto</h5>
        <div class="mb-3">
            <label>Descrição</label>
            <input type="text" name="produto_descricao" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Quantidade</label>
            <input type="number" step="0.01" name="produto_quantidade" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Valor Unitário (R$)</label>
            <input type="number" step="0.01" name="produto_valor" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-primary">Emitir NF-e</button>
    </form>
</body>
</html>
