<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once 'vendor/autoload.php';
require_once 'config.php';

use NFePHP\Common\Certificate;
use NFePHP\NFe\Make;
use NFePHP\NFe\Tools;

// Carregar certificado
$certificado = file_get_contents(__DIR__ . '/certificado/1.pfx');
$senha = 'aej123'; // sua senha do .pfx
$cert = Certificate::readPfx($certificado, $senha);

// Inicializar ferramentas
$tools = new Tools($configJson, $cert);
$tools->model('55');

// Receber dados do formulário
$cliente_nome = $_POST['cliente_nome'];
$cliente_cpf_cnpj = preg_replace('/\D/', '', $_POST['cliente_cpf_cnpj']);
$cliente_endereco = $_POST['cliente_endereco'];
$cliente_municipio = $_POST['cliente_municipio'];
$cliente_uf = $_POST['cliente_uf'];
$produto_descricao = $_POST['produto_descricao'];
$produto_qtd = number_format($_POST['produto_quantidade'], 2, '.', '');
$produto_valor = number_format($_POST['produto_valor'], 2, '.', '');
$produto_total = number_format($produto_qtd * $produto_valor, 2, '.', '');

// Montar XML com NFePHP\NFe\Make
$nfe = new Make();
$nfe->version = '4.00';

$std = new stdClass();
$std->versao = '4.00';
$std->Id = null;
$std->indSinc = 1;
$nfe->taginfNFe($std);

// Emitente (fixo para testes)
$emit = new stdClass();
$emit->xNome = 'Empresa de Teste LTDA';
$emit->IE = '1234567890';
$emit->CRT = 1;
$emit->CNPJ = '12345678000199';
$nfe->tagemit($emit);

// Endereço do emitente
$enderEmit = new stdClass();
$enderEmit->xLgr = 'Rua Exemplo';
$enderEmit->nro = '100';
$enderEmit->xBairro = 'Centro';
$enderEmit->cMun = '3550308'; // Código de São Paulo
$enderEmit->xMun = 'São Paulo';
$enderEmit->UF = 'SP';
$enderEmit->CEP = '01001000';
$enderEmit->cPais = '1058';
$enderEmit->xPais = 'Brasil';
$nfe->tagenderEmit($enderEmit);

// Destinatário (cliente)
$dest = new stdClass();
$dest->xNome = $cliente_nome;
$dest->indIEDest = 9;
$dest->CPF = strlen($cliente_cpf_cnpj) == 11 ? $cliente_cpf_cnpj : null;
$dest->CNPJ = strlen($cliente_cpf_cnpj) == 14 ? $cliente_cpf_cnpj : null;
$dest->email = 'cliente@exemplo.com';
$nfe->tagdest($dest);

// Endereço do destinatário
$enderDest = new stdClass();
$enderDest->xLgr = $cliente_endereco;
$enderDest->nro = '0';
$enderDest->xBairro = 'Bairro';
$enderDest->cMun = '3550308';
$enderDest->xMun = $cliente_municipio;
$enderDest->UF = $cliente_uf;
$enderDest->CEP = '01001000';
$enderDest->cPais = '1058';
$enderDest->xPais = 'Brasil';
$nfe->tagenderDest($enderDest);

// Produto
$prod = new stdClass();
$prod->item = 1;
$prod->cProd = '001';
$prod->xProd = $produto_descricao;
$prod->NCM = '61091000';
$prod->CFOP = '5102';
$prod->uCom = 'UN';
$prod->qCom = $produto_qtd;
$prod->vUnCom = $produto_valor;
$prod->vProd = $produto_total;
$prod->uTrib = 'UN';
$prod->qTrib = $produto_qtd;
$prod->vUnTrib = $produto_valor;
$prod->indTot = 1;
$nfe->tagprod($prod);

// Impostos (zerados para simples nacional)
$imposto = new stdClass();
$imposto->item = 1;
$imposto->vTotTrib = 0.00;
$nfe->tagimposto($imposto);

$icms = new stdClass();
$icms->item = 1;
$icms->orig = 0;
$icms->CSOSN = '102';
$nfe->tagICMSSN102($icms);

$ipi = new stdClass();
$ipi->item = 1;
$ipi->cEnq = '999';
$nfe->tagIPI($ipi);

$piscofins = new stdClass();
$piscofins->item = 1;
$piscofins->CST = '99';
$piscofins->vBC = 0.00;
$piscofins->pPIS = 0.00;
$piscofins->vPIS = 0.00;
$piscofins->pCOFINS = 0.00;
$piscofins->vCOFINS = 0.00;
$nfe->tagPIS($piscofins);
$nfe->tagCOFINS($piscofins);

// Totais
$total = new stdClass();
$total->vProd = $produto_total;
$total->vNF = $produto_total;
$nfe->tagICMSTot($total);

// Transporte (sem frete)
$transp = new stdClass();
$transp->modFrete = 9;
$nfe->tagtransp($transp);

// Pagamento
$pag = new stdClass();
$pag->tPag = '01'; // Dinheiro
$pag->vPag = $produto_total;
$nfe->tagpag($pag);

// Informações adicionais
$infAdic = new stdClass();
$infAdic->infCpl = 'Nota emitida em ambiente de homologação.';
$nfe->taginfAdic($infAdic);

// Gerar XML
$xml = $nfe->getXML();

try {
    // Assinar e enviar
    $xmlAssinado = $tools->signNFe($xml);
    $ret = $tools->sefazEnviaLote([$xmlAssinado], 1);

    $stdRet = json_decode($ret);
    if ($stdRet->cStat == 103 || $stdRet->cStat == 104) {
        // Autorizada
        $protocolo = $tools->sefazConsultaRecibo($stdRet->infRec->nRec);
        file_put_contents("xml/nota_autorizada.xml", $xmlAssinado);
        header("Location: gerar_danfe.php");
        exit;
    } else {
        echo "<h3>❌ Erro: {$stdRet->xMotivo}</h3>";
    }

} catch (Exception $e) {
    echo "Erro na emissão: " . $e->getMessage();
}
